#!/usr/bin/perl

# Very simple Perl script for sending commands to Marcus Mueller's IRServer software
# USE AT OWN RISK

use strict;
use CGI;
use IO::Socket;
# uncomment next line if you need to insert pauses
# smaller than 1s between command when sending macros
# use Time::HiRes;

my $p = new CGI();

print $p->header(-type=>'text/html');
print "<META HTTP-EQUIV=\"Refresh\" CONTENT=\"3; URL=/null.html\">";

if ($p->param('macro')) {
	&sendmacro($p->param('macro'));	
	print "OK macro " . $p->param('macro'). " sent\n";
}
elsif ($p->param('cmd')) {
	&sendcmd(split(/\+/, $p->param('cmd')));
	#print $p->redirect($p->referer()); # if you want to use reload rather than frames
}	

sub sendmacro {
	
	my ($macro) = @_;
	my @line;
	
	
	open (MACROS, 'macros') || die;
	while(@line = split(/\s+/, <MACROS>)) {
		if ($line[0] eq $macro) {
			print "macro $line[0] remote $line[1]\n";
			my $cmd;
			foreach $cmd (@line[2..scalar(@line)-1]) {
				&sendcmd($line[1], $cmd);
				# sleep for 500ms				
				# usleep(500000); 
			}
			last;
		} 
	}
	close (MACROS);
}

sub sendcmd {

my ($rem, $cmd) = @_;
	
my $remote = IO::Socket::INET->new(
	Proto    => "tcp",
	PeerAddr => "localhost",
	PeerPort => "8765",
	)
 or die "cannot connect to IRTRANS server";

$remote->autoflush(1);

print "sending $cmd to device  $rem\n";	

print $remote "SEND_ONCE $rem $cmd\n";

close ($remote);

}
